/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track;

import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.source.AudioSourceManager;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.AudioTrackState;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.InternalAudioTrack;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.TrackMarker;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.playback.AudioFrame;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.playback.AudioTrackExecutor;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.playback.MutableAudioFrame;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.playback.PrimordialAudioTrackExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public abstract class BaseAudioTrack
implements InternalAudioTrack {
    private final PrimordialAudioTrackExecutor initialExecutor;
    private final AtomicBoolean executorAssigned;
    private volatile AudioTrackExecutor activeExecutor;
    protected final AudioTrackInfo trackInfo;
    protected final AtomicLong accurateDuration;
    private volatile Object userData;

    public BaseAudioTrack(AudioTrackInfo trackInfo) {
        this.initialExecutor = new PrimordialAudioTrackExecutor(trackInfo);
        this.executorAssigned = new AtomicBoolean();
        this.activeExecutor = null;
        this.trackInfo = trackInfo;
        this.accurateDuration = new AtomicLong();
    }

    @Override
    public void assignExecutor(AudioTrackExecutor executor, boolean applyPrimordialState) {
        if (this.executorAssigned.compareAndSet(false, true)) {
            if (applyPrimordialState) {
                this.initialExecutor.applyStateToExecutor(executor);
            }
        } else {
            throw new IllegalStateException("Cannot play the same instance of a track twice, use track.makeClone().");
        }
        this.activeExecutor = executor;
    }

    @Override
    public AudioTrackExecutor getActiveExecutor() {
        AudioTrackExecutor executor = this.activeExecutor;
        return executor != null ? executor : this.initialExecutor;
    }

    @Override
    public void stop() {
        this.getActiveExecutor().stop();
    }

    @Override
    public AudioTrackState getState() {
        return this.getActiveExecutor().getState();
    }

    @Override
    public String getIdentifier() {
        return this.trackInfo.identifier;
    }

    @Override
    public boolean isSeekable() {
        return !this.trackInfo.isStream;
    }

    @Override
    public long getPosition() {
        return this.getActiveExecutor().getPosition();
    }

    @Override
    public void setPosition(long position) {
        this.getActiveExecutor().setPosition(position);
    }

    @Override
    public void setMarker(TrackMarker marker) {
        this.getActiveExecutor().setMarker(marker);
    }

    @Override
    public AudioFrame provide() {
        return this.getActiveExecutor().provide();
    }

    @Override
    public AudioFrame provide(long timeout, TimeUnit unit) throws TimeoutException, InterruptedException {
        return this.getActiveExecutor().provide(timeout, unit);
    }

    @Override
    public boolean provide(MutableAudioFrame targetFrame) {
        return this.getActiveExecutor().provide(targetFrame);
    }

    @Override
    public boolean provide(MutableAudioFrame targetFrame, long timeout, TimeUnit unit) throws TimeoutException, InterruptedException {
        return this.getActiveExecutor().provide(targetFrame, timeout, unit);
    }

    @Override
    public AudioTrackInfo getInfo() {
        return this.trackInfo;
    }

    @Override
    public long getDuration() {
        long accurate = this.accurateDuration.get();
        if (accurate == 0L) {
            return this.trackInfo.length;
        }
        return accurate;
    }

    @Override
    public AudioTrack makeClone() {
        AudioTrack track = this.makeShallowClone();
        track.setUserData(this.userData);
        return track;
    }

    @Override
    public AudioSourceManager getSourceManager() {
        return null;
    }

    @Override
    public AudioTrackExecutor createLocalExecutor(AudioPlayerManager playerManager) {
        return null;
    }

    @Override
    public void setUserData(Object userData) {
        this.userData = userData;
    }

    @Override
    public Object getUserData() {
        return this.userData;
    }

    @Override
    public <T> T getUserData(Class<T> klass) {
        Object data = this.userData;
        if (data != null && klass.isAssignableFrom(data.getClass())) {
            return (T)data;
        }
        return null;
    }

    protected AudioTrack makeShallowClone() {
        throw new UnsupportedOperationException();
    }
}

